function [CV, CV_2, Theil_T, Theil_T_2, Theil_L, Theil_L_2, VarianceLog1, VarianceLog2, AssortHHIncPremium, AssortHHIncPremium2, E_beta, E_beta2] = ...
    MeIneqMeasures(beta, qq, Nf, Psim, Psif, wS_m, wS_f, wU_m, wU_f)

qSS_m=qq(1);
qSS_f=qq(2);
qUS_m=qq(3);
qUS_f=qq(4);
qSU_m=qq(5);
qSU_f=qq(6);
qUU_m=qq(7);
qUU_f=qq(8);

thetaSm=(1-Nf)*Psim+Nf*Psim*Psif*max(qSS_m,qSS_f)+Nf*Psim*(1-Psif)*max(qSU_m,qSU_f);
thetaUm=(1-Nf)*(1-Psim)+Nf*(1-Psim)*Psif*max(qUS_m,qUS_f)+Nf*(1-Psim)*(1-Psif)*max(qUU_m,qUU_f);
thetaSf=Nf*Psim*Psif*max(qSS_m,qSS_f)+Nf*(1-Psim)*Psif*max(qUS_m,qUS_f);
thetaUf=Nf*Psim*(1-Psif)*max(qSU_m,qSU_f)+Nf*(1-Psim)*(1-Psif)*max(qUU_m,qUU_f);

piss=Nf*Psim*Psif*(1-max(qSS_m,qSS_f))+ min(thetaSm,thetaSf);
pisu=Nf*Psim*(1-Psif)*(1-max(qSU_m,qSU_f));
pius=Nf*(1-Psim)*Psif*(1-max(qUS_m,qUS_f));
piuu=Nf*(1-Psim)*(1-Psif)*(1-max(qUU_m,qUU_f))+min(thetaUm,thetaUf);
pis=max(thetaSm-thetaSf,0);
piu=max(thetaUm-thetaUf,0);
 
HH_Inc_ss = wS_m+wS_f;
HH_Inc_su = wS_m+wU_f;
HH_Inc_us = wU_m+wS_f;
HH_Inc_uu = wU_m+wU_f;
HH_Inc_s  = wS_m;
HH_Inc_u  = wU_m;

I_SS=piss*HH_Inc_ss;
I_SU=pisu*HH_Inc_su;
I_US=pius*HH_Inc_us;
I_UU=piuu*HH_Inc_uu;
I_S=pis*HH_Inc_s; 
I_U=piu*HH_Inc_u;

pop=piss+pisu+pius+piuu+pis+piu;

pop_2 = piss+pisu+pius+piuu;

mean_I = (I_SS+I_SU+I_US+I_UU+I_S+I_U)/pop;

mean_I_2 = (I_SS+I_SU+I_US+I_UU)/pop_2;

%% Coefficient of variance
variance_1 = piss*(HH_Inc_ss-mean_I)^2;
variance_2 = pisu*(HH_Inc_su-mean_I)^2;
variance_3 = pius*(HH_Inc_us-mean_I)^2;
variance_4 = piuu*(HH_Inc_uu-mean_I)^2;
variance_5 = pis*(HH_Inc_s-mean_I)^2;
variance_6 = piu*(HH_Inc_u-mean_I)^2;

variance = (variance_1+variance_2+variance_3+variance_4+variance_5+variance_6)/pop;

CV = (sqrt(variance))/mean_I;

%% Coefficient of variance excluding singles
v_1 = piss*(HH_Inc_ss-mean_I_2)^2;
v_2 = pisu*(HH_Inc_su-mean_I_2)^2;
v_3 = pius*(HH_Inc_us-mean_I_2)^2;
v_4 = piuu*(HH_Inc_uu-mean_I_2)^2;

variance_2 = (v_1+v_2+v_3+v_4)/pop_2;

CV_2 = (sqrt(variance_2))/mean_I_2;

%% Theil index

r_ss = piss*((wS_m+wS_f)/mean_I)*log((wS_m+wS_f)/mean_I);
r_su = pisu*((wS_m+wU_f)/mean_I)*log((wS_m+wU_f)/mean_I);
r_us = pius*((wU_m+wS_f)/mean_I)*log((wU_m+wS_f)/mean_I);
r_uu = piuu*((wU_m+wU_f)/mean_I)*log((wU_m+wU_f)/mean_I);
r_s  = pis*(wS_m/mean_I)*log(wS_m/mean_I);
r_u  = piu*(wU_m/mean_I)*log(wU_m/mean_I);

m_ss = piss*log(mean_I/(wS_m+wS_f));
m_su = pisu*log(mean_I/(wS_m+wU_f));
m_us = pius*log(mean_I/(wU_m+wS_f));
m_uu = piuu*log(mean_I/(wU_m+wU_f));
m_s  = pis*log(mean_I/wS_m);
m_u  = piu*log(mean_I/wU_m);

Theil_T = (r_ss+r_su+r_us+r_uu+r_s+r_u)/pop;

Theil_L = (m_ss+m_su+m_us+m_uu+m_s+m_u)/pop;

%% Theil index excluding singles

r_ss_2 = piss*((wS_m+wS_f)/mean_I_2)*log((wS_m+wS_f)/mean_I_2);
r_su_2 = pisu*((wS_m+wU_f)/mean_I_2)*log((wS_m+wU_f)/mean_I_2);
r_us_2 = pius*((wU_m+wS_f)/mean_I_2)*log((wU_m+wS_f)/mean_I_2);
r_uu_2 = piuu*((wU_m+wU_f)/mean_I_2)*log((wU_m+wU_f)/mean_I_2);

m_ss_2 = piss*log(mean_I_2/(wS_m+wS_f));
m_su_2 = pisu*log(mean_I_2/(wS_m+wU_f));
m_us_2 = pius*log(mean_I_2/(wU_m+wS_f));
m_uu_2 = piuu*log(mean_I_2/(wU_m+wU_f));

Theil_T_2 = (r_ss_2+r_su_2+r_us_2+r_uu_2)/pop_2;

Theil_L_2 = (m_ss_2+m_su_2+m_us_2+m_uu_2)/pop_2;

%% Logarithmic variance
c_ss = piss*(log(HH_Inc_ss/mean_I))^2;
c_su = pisu*(log(HH_Inc_su/mean_I))^2;
c_us = pius*(log(HH_Inc_us/mean_I))^2;
c_uu = piuu*(log(HH_Inc_uu/mean_I))^2;
c_s  = pis*(log(HH_Inc_s/mean_I))^2;
c_u  = piu*(log(HH_Inc_u/mean_I))^2;

VarianceLog1 = (c_ss+c_su+c_us+c_uu+c_s+c_u)/pop;

%% Logarithmic variance excluding singles
c_ss_2 = piss*(log(HH_Inc_ss/mean_I_2))^2;
c_su_2 = pisu*(log(HH_Inc_su/mean_I_2))^2;
c_us_2 = pius*(log(HH_Inc_us/mean_I_2))^2;
c_uu_2 = piuu*(log(HH_Inc_uu/mean_I_2))^2;

VarianceLog2 = (c_ss_2+c_su_2+c_us_2+c_uu_2)/pop_2;

%% Assort. HH inc premium

AssortHHIncPremium = (I_SS+I_UU)/(I_SU+I_US+I_S+I_U);

%% Assort. HH inc premium excluding singles

AssortHHIncPremium2 = (I_SS+I_UU)/(I_SU+I_US);


%% General form
z_ss = piss*((HH_Inc_ss/mean_I)^beta);
z_su = pisu*((HH_Inc_su/mean_I)^beta);
z_us = pius*((HH_Inc_us/mean_I)^beta);
z_uu = piuu*((HH_Inc_uu/mean_I)^beta);
z_s = pis*((HH_Inc_s/mean_I)^beta);
z_u = piu*((HH_Inc_u/mean_I)^beta);

E_beta = (1/(beta^2-beta))*(((z_ss+z_su+z_us+z_uu+z_s+z_u)/pop)-1);

%% General form excluding singles
z_ss_2 = piss*((HH_Inc_ss/mean_I_2)^beta);
z_su_2 = pisu*((HH_Inc_su/mean_I_2)^beta);
z_us_2 = pius*((HH_Inc_us/mean_I_2)^beta);
z_uu_2 = piuu*((HH_Inc_uu/mean_I_2)^beta);

E_beta2 = (1/(beta^2-beta))*(((z_ss_2+z_su_2+z_us_2+z_uu_2)/pop_2)-1);

end